/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.en.AvsAnData;
import org.languagetool.tools.StringTools;

public class AvsAnRule
extends Rule {
    private static final Pattern cleanupPattern = Pattern.compile("[^\u03b1a-zA-Z0-9\\.;,:']");

    public AvsAnRule(ResourceBundle messages) {
        super.setCategory(Categories.MISC.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong("The train arrived <marker>a hour</marker> ago."), Example.fixed("The train arrived <marker>an hour</marker> ago."));
    }

    @Override
    public String getId() {
        return "EN_A_VS_AN";
    }

    @Override
    public String getDescription() {
        return "Use of 'a' vs. 'an'";
    }

    @Override
    public int estimateContextForSureMatch() {
        return 1;
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        int prevTokenIndex = 0;
        for (int i = 1; i < tokens.length; ++i) {
            boolean equalsAn;
            boolean equalsA;
            boolean isSentenceStart;
            AnalyzedTokenReadings token = tokens[i];
            String prevTokenStr = prevTokenIndex > 0 ? tokens[prevTokenIndex].getToken() : null;
            boolean bl = isSentenceStart = prevTokenIndex == 1;
            if (!isSentenceStart) {
                equalsA = "a".equals(prevTokenStr);
                equalsAn = "an".equals(prevTokenStr);
            } else {
                equalsA = "a".equalsIgnoreCase(prevTokenStr);
                equalsAn = "an".equalsIgnoreCase(prevTokenStr);
            }
            if (equalsA || equalsAn) {
                String replacement;
                Determiner determiner = this.getCorrectDeterminerFor(token);
                String msg = null;
                if (equalsA && determiner == Determiner.AN) {
                    replacement = StringTools.startsWithUppercase(prevTokenStr) ? "An" : "an";
                    msg = "Use <suggestion>" + replacement + "</suggestion> instead of '" + prevTokenStr + "' if the following word starts with a vowel sound, e.g. 'an article', 'an hour'";
                } else if (equalsAn && determiner == Determiner.A) {
                    replacement = StringTools.startsWithUppercase(prevTokenStr) ? "A" : "a";
                    msg = "Use <suggestion>" + replacement + "</suggestion> instead of '" + prevTokenStr + "' if the following word doesn't start with a vowel sound, e.g. 'a sentence', 'a university'";
                }
                if (msg != null) {
                    RuleMatch match = new RuleMatch(this, sentence, tokens[prevTokenIndex].getStartPos(), tokens[prevTokenIndex].getEndPos(), msg, "Wrong article");
                    ruleMatches.add(match);
                }
            }
            if (token.hasPosTag("DT")) {
                prevTokenIndex = i;
                continue;
            }
            if (token.getToken().matches("[-\"()\\[\\]]+")) continue;
            prevTokenIndex = 0;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    public String suggestAorAn(String origWord) {
        AnalyzedTokenReadings token = new AnalyzedTokenReadings(new AnalyzedToken(origWord, null, null), 0);
        Determiner determiner = this.getCorrectDeterminerFor(token);
        if (determiner == Determiner.A || determiner == Determiner.A_OR_AN) {
            return "a " + origWord;
        }
        if (determiner == Determiner.AN) {
            return "an " + origWord;
        }
        return origWord;
    }

    Determiner getCorrectDeterminerFor(AnalyzedTokenReadings token) {
        String word = token.getToken();
        Determiner determiner = Determiner.UNKNOWN;
        String[] parts = word.split("[-']");
        if (parts.length >= 1 && !parts[0].equalsIgnoreCase("a")) {
            word = parts[0];
        }
        if ((token.isWhitespaceBefore() || !"-".equals(word)) && StringTools.isEmpty(word = cleanupPattern.matcher(word).replaceAll(""))) {
            return Determiner.UNKNOWN;
        }
        if (AvsAnData.getWordsRequiringA().contains(word.toLowerCase()) || AvsAnData.getWordsRequiringA().contains(word)) {
            determiner = Determiner.A;
        }
        if (AvsAnData.getWordsRequiringAn().contains(word.toLowerCase()) || AvsAnData.getWordsRequiringAn().contains(word)) {
            determiner = determiner == Determiner.A ? Determiner.A_OR_AN : Determiner.AN;
        }
        if (determiner == Determiner.UNKNOWN) {
            char tokenFirstChar = word.charAt(0);
            determiner = StringTools.isAllUppercase(word) || StringTools.isMixedCase(word) ? Determiner.UNKNOWN : (this.isVowel(tokenFirstChar) ? Determiner.AN : Determiner.A);
        }
        return determiner;
    }

    private boolean isVowel(char c) {
        char lc = Character.toLowerCase(c);
        return lc == 'a' || lc == 'e' || lc == 'i' || lc == 'o' || lc == 'u';
    }

    static enum Determiner {
        A,
        AN,
        A_OR_AN,
        UNKNOWN;

    }
}

